/* This code is for the Bluetooth APP used for ESP-32 by electronicsforu.com. Author: Kunal Verma*/
#include <BLEDevice.h>
#include <BLEServer.h>
#include <BLEUtils.h>
#include <BLE2902.h>        // These are the Bluetooth Libraries used

BLECharacteristic * pCharacteristic;

bool deviceConnected = false;                                              // a variable declared to check the connection
const int LED = 5;                                                         // You can use various other pins of the ESP board. We used GPIO 5

#define SERVICE_UUID "6E400001-B5A3-F393-E0A9-E50E24DCCA9E"                // UART service UUID
#define CHARACTERISTIC_UUID_RX "6E400002-B5A3-F393-E0A9-E50E24DCCA9E"      // See the following link if you want to generate your own UUIDs:
#define DHTDATA_CHAR_UUID "6E400003-B5A3-F393-E0A9-E50E24DCCA9E"           // https://www.uuidgenerator.net/

class MyServerCallbacks: public BLEServerCallbacks                         // Class created to check the server connection
{
    void onConnect (BLEServer * pServer) 
    {
      deviceConnected = true;
    };
    void onDisconnect (BLEServer * pServer) 
    {
      deviceConnected = false;
    }
};

class MyCallbacks: public BLECharacteristicCallbacks               // Class created to control the LED using the recieved commands from the Android App
{
    void onWrite (BLECharacteristic * pCharacteristic) 
    {
      std :: string rxValue = pCharacteristic-> getValue ();
      Serial.println (rxValue [0]);                          
      if (rxValue.length() > 0)                               
      {
        Serial.println("*********");                              //to print the recieved value
        Serial.print("Received Value: ");
        for (int i = 0; i < rxValue.length(); i++) 
        {
          Serial.print(rxValue[i]);
        }
        Serial.println();
        if (rxValue.find("A") != -1)          // Do things based on the command received from the android app
        { 
          Serial.println("Turning ON!");
          digitalWrite(LED, HIGH);            //Print and control the LED
        }
        else if (rxValue.find("B") != -1) 
        {
          Serial.println("Turning OFF!");
          digitalWrite(LED, LOW);
        }
        Serial.println();
        Serial.println("*********");
      }
   }
};

void setup () 
{
  Serial.begin (115200);
  pinMode (LED, OUTPUT);
  BLEDevice :: init ("ESP32 Bluetooth Test");                                       // Create the BLE Device and give your device a name within the double qoutes
  BLEServer * pServer = BLEDevice :: createServer ();                               // Set the device in BLE Server mode
  pServer-> setCallbacks (new MyServerCallbacks ());
  BLEService * pService = pServer-> createService (SERVICE_UUID);                   // Create the UART service for the transmission and reception of data                    
  pCharacteristic-> addDescriptor (new BLE2902 ());
  BLECharacteristic * pCharacteristic = pService-> createCharacteristic (CHARACTERISTIC_UUID_RX, BLECharacteristic :: PROPERTY_WRITE);// creates a BLE characteristic to receive the data
  pCharacteristic-> setCallbacks (new MyCallbacks ());
  pCharacteristic = pService-> createCharacteristic                                 // You can also create a service to send the data in case of sensors
  (
      DHTDATA_CHAR_UUID,                                                            // To get the UUID
      BLECharacteristic :: PROPERTY_NOTIFY
  );
  pService-> start ();                                                              // Start the bluetooth service. This needs to be started only once
  pServer-> getAdvertising () -> start ();                                          // Start the discovery of ESP32 to get discovered by other bluetooth device.
  Serial.println ("Waiting for a client to connect ...");
}

void loop () 
{
  if (deviceConnected) 
  {}
  delay (500);
}
